knex = require('knex');

connection = {
	host : '127.0.0.1',
	port : 3306,
	user : 'root',
	password : '',
	database : 'whatsgw',
}

const _knex = knex({
	client: 'mysql2',
	connection,
	debug: false,
    pool: {
      min: 2,
      max: 99,
    },
});

class database {

	constructor() {
		this.table = _knex;
	}

	async transaction(trx) {
		return trx(await this.table.transaction());
	}

	async startTransaction() {
		this._trx = await this.table.transaction();
	    return this._trx;
	}

	async finishTransaction() {
		await this._trx.commit();
		this._trx = (function () { return; })();
		return true;
	}

	async rollbackTransaction() {
		return this._trx.rollback();
	}

}

module.exports = database;