const pwhash = require('password-hash');
const jwt = require("jsonwebtoken");
const md5 = require("md5");
const moment = require("moment");
const uniqid = require("uniqid");

exports.login = ($) => {
	const __constructor = async function(req, res) {

		try {
			if(req.validate.isEmpty()) {
				const username = req.body.username.toString().replace(/[^0-9a-z\@\.\_\-]/g)
				let user = await $.model("users").findOne([
					['whereRaw', `(username = "${username}" or email = "${username}")`],
				]);

				if(user) {

					switch(user.status) {
						case 'active':
							let confirm = pwhash.verify(req.body.password, user.password);
							if(confirm) {
								let token = jwt.sign({
									id: user.id,
								}, $.config("app").jwtPrivateKey, {
									expiresIn: "24h"
								});

								res.cookie($.config("app").session_name, token, {
									httpOnly: true,
									// secure: true,
									maxAge: 3600000 * 24
								});

								$.service('attempts').login_success(req, user.id);
								return res.json({
									redirect_to: $.base_url(`member_area/dashboard`),
									message: "Login berhasil.",
									token: token
								});
							} else {
								$.service('attempts').login_fail(req, user.id, "Password not match");
								return res.status(400).json({
									"message": "password not match."
								});
							}
						break;

						case 'inactive':
							$.service('attempts').login_fail(req, user.id, "Account inactived");
							return res.status(400).json({
								"message": "akun tidak aktif."
							});
						break;

						case 'suspend':
							$.service('attempts').login_fail(req, user.id, "Account has been banned");
							return res.status(400).json({
								"message": "akun telah ditangguhkan."
							});
						break;

						default:
							$.service('attempts').login_fail(req, user.id, "Account being verification");
							return res.status(400).json({
								"message": "akun belum diverifikasi"
							});
						break;
					}

				} else {
					return res.status(400).json({
						"message": "user not found."
					});
				}
			} else {
				return res.status(400).json({
					message: "Periksa kembali form anda.",
					errors: req.validate.get_errors()
				});
			}
		} catch(err) {
			console.log(err);
			return res.status(500).json({message: 'error tidak diketahui'});
		}

	}

	return __constructor;
}

exports.register = ($) => {
	const __constructor = async function(req, res) {
		try {

			if(req.validate.isEmpty()) {

				const usernameCheck = await $.model('users').findOne([
					['where', 'username', req.body.username]
				]);

				if(usernameCheck) {
					return res.status(400).json({
						message: "Periksa kembali form anda.",
						errors: {
							username: 'Username sudah digunakan.',
						}
					});
				}

				const emailCheck = await $.model('users').findOne([
					['where', 'email', req.body.email]
				]);

				if(emailCheck) {
					return res.status(400).json({
						message: "Periksa kembali form anda.",
						errors: {
							email: 'Email sudah digunakan'
						}
					});
				}

				var pw = req.body.password;
				var plain_pw = `${pw}`;
				var pwc = req.body.password_confirm;
				var update_password = false;

				if (pw === pwc) {
					pw = pwhash.generate(pw);
					update_password = true;
				} else {
					return res.status(400).json({
						message: "Periksa kembali form anda.",
						errors: {
							password_confirm: 'Kata sandi tidak sesuai.'
						}
					});
				}

				var formdata = {
					name: req.body.name.replace(/[^0-9A-Za-z\s]/g, ''),
					username: req.body.username.toLowerCase().replace(/[^0-9a-z]/g, ''),
					email: req.body.email.toLowerCase().replace(/[^0-9a-z\@\.\_\-]/g, ''),
					phone: req.body.phone.replace(/[^0-9]/g, ""),
					group: 'member',
					password: pw,
					api_key: uniqid(),
					photo: 'user.png'
				};

				await $.model('users').insert(formdata);
				$.service('mail').welcome({
					name: formdata.name,
					email: formdata.email,
					username: formdata.username,
					password: plain_pw,
				});
				return res.json({
					message: "Berhasil mendaftarkan, silahkan login!"
				});
			} else {
				return res.status(400).json({
					message: "Periksa kembali form anda.",
					errors: req.validate.get_errors()
				});
			}
		} catch (err) {
			console.log(err);
			return res.status(500).json({message: 'error tidak diketahui'});
		}
	}

	return __constructor;
}

exports.forgot = ($) => {
	const __constructor = async function(req, res) {

		try {
			if(req.validate.isEmpty()) {
				const email = req.body.email.toString().replace(/[^0-9a-z\@\.\_\-]/g)
				let user = await $.model("users").findOne([
					['whereRaw', `(username = "${email}" or email = "${email}")`],
				]);

				if(user) {

					switch(user.status) {
						case 'active':
							const token = md5(`${new Date().getTime()}.${Math.random().toString().substr(2)}`);
							const expired_at = moment().add(1, 'DAY').format("YYYY-MM-DD HH:mm:ss");
							const url = $.base_url(`auth/forgot/${token}`);
							
							await $.model('tokens').insert({
								user_id: user.id,
								type: 'Lost Password',
								token: token,
								expired_at: expired_at
							});

							$.service('mail').forgot({
								name: user.name,
								email: user.email,
								username: user.username,
								url: url,
							});
							
							return res.json({
								redirect_to: $.base_url(`auth/login`),
								message: `Link reset kata sandi telah dikirim ke email anda (${user.email}).`,
							});
						break;

						case 'inactive':
							$.service('attempts').login_fail(req, user.id, "Account inactived");
							return res.status(400).json({
								"message": "akun tidak aktif."
							});
						break;

						case 'suspend':
							$.service('attempts').login_fail(req, user.id, "Account has been banned");
							return res.status(400).json({
								"message": "akun telah ditangguhkan."
							});
						break;

						default:
							$.service('attempts').login_fail(req, user.id, "Account being verification");
							return res.status(400).json({
								"message": "akun belum diverifikasi"
							});
						break;
					}

				} else {
					return res.status(400).json({
						"message": "user not found."
					});
				}
			} else {
				return res.status(400).json({
					message: "Periksa kembali form anda.",
					errors: req.validate.get_errors()
				});
			}
		} catch(err) {
			console.log(err);
			return res.status(500).json({message: 'error tidak diketahui'});
		}

	}

	return __constructor;
}

exports.new_password = ($) => {
	const __constructor = async function(req, res) {

		try {
			if(req.validate.isEmpty()) {
				const tokenParam = $.helper('text').sanitize_alphanum(req.body.token);
				const token = await $.model('tokens').findOne([
					['where', 'token', tokenParam],
					['where', 'expired_at', '>=', moment().format('YYYY-MM-DD HH:mm:ss')]
				]);
				if(token) {
					const redirect_to = $.base_url('member_area/');
					const password = req.body.password;
					const password_confirm = req.body.password_confirm;

					if(password !== password_confirm) {
						return res.status(400).json({
							message: "Konfirmasi sandi tidak sesuai.",
						});
					}
					const db = $.config('database');
					await db.table.transaction(async function(trx){
						await $.model('tokens').setTransaction(trx).delete(token.id);
						await $.model('users').setTransaction(trx).update(token.user_id, {
							password: pwhash.generate(password),
							updated_by: token.user_id
						});
						await trx.commit();
					});
					
					let jwtToken = jwt.sign({
						id: token.user_id,
					}, $.config("app").jwtPrivateKey, {
						expiresIn: "24h"
					});

					res.cookie($.config("app").session_name, jwtToken, {
						httpOnly: true,
						secure: true,
						maxAge: 3600000 * 24
					});

					$.service('attempts').login_success(req, token.user_id, "Login After Confirmation New Password");
					return res.json({
						message: "Kata sandi berhasil diperbarui.",
						redirect_to: redirect_to
					});
				} else {
					return res.status(400).json({
						message: "Token kadaluarsa, silahkan ulang proses sekali lagi.",
					});
				}
			} else {
				return res.status(400).json({
					message: "Periksa kembali form anda.",
					errors: req.validate.get_errors()
				});
			}
		} catch(err) {
			console.log(err);
			return res.status(500).json({message: 'error tidak diketahui'});
		}

	}

	return __constructor;
}