const uniqid = require('uniqid');
const moment = require('moment');
const devices = require('../../statics/devices.js');

exports.events = ($) => {

	const __constructor = async function(req, res) {

	}

	return __constructor;
}

exports.create = ($) => {

	const __constructor = async function(req, res) {

	}

	return __constructor;
}

exports.update = ($) => {

	const __constructor = async function(req, res) {
		try {
			if(req.validate.isEmpty()) {
				const id = $.helper('text').sanitize_int(req.params.id);
				const name = req.body.name;
				const webhook_url = req.body.webhook_url;
				const status = typeof req.body.status == 'string' ? $.helper('text').sanitize_alphanum(req.body.status) : "";
				const device = await $.model('devices').findOne([
					['where', 'id', '=', id],
					['where', 'user_id', '=', req.auth.user('id')],
					['whereIn', 'status', ['active', 'inactive']],
				]);
				if(device) {
					const data = new Object();
					data.name = name;

					if(status) {
						data.status = status;
						if(status=='inactive' && devices.get(device.session)) {
							devices.get(device.session).stop();
						}
					}

					if(webhook_url) {
						if($.helper('text').isValidUrl(webhook_url)) {
							data.webhook_url = webhook_url;
							if(devices.get(device.session)) {
								devices.get(device.session).webhook_url = webhook_url;
							}
						} else {
							return res.status(400).json({
								message: "URL webhook tidak sesuai",
							});
						}
					} else {
						data.webhook_url = null;
						if(devices.get(device.session)) {
							devices.get(device.session).webhook_url = null;
						}
					}

					data.updated_by = req.auth.user('id');
					await $.model('devices').update(id, data);

					return res.json({
						message: "Perubahan disimpan!"
					});
				} else {
					return res.status(400).json({
						message: "Perubahan gagal disimpan!",
					});
				}
			} else {
				return res.status(400).json({
					message: "Periksa kembali form anda.",
					errors: req.validate.get_errors()
				});
			}
		} catch(err) {
			console.log(err);
			return res.status(500).json({message: 'error tidak diketahui'});
		}
	}

	return __constructor;
}

exports.devices = ($) => {

	const __constructor = async function(req, res) {

		const datatable = $.library('datatables');

		try {
			datatable.init('devices');
			datatable.rest(req, res);
			datatable.search('session', 'name', 'status', 'status_sub', 'expired_at', 'id');
			datatable.params([
				['select', 'session', 'name', 'status', 'status_sub', 'expired_at', 'id'],
				['where', 'devices.user_id', '=', req.auth.user('id')],
			]);
			return await datatable.render();
		} catch(err) {
			res.status(500).json({
				message: err
			});
		}
	}

	return __constructor;
}

exports.webhooks = ($) => {

	const __constructor = async function(req, res) {

		const datatable = $.library('datatables');

		try {
			datatable.init('webhooks');
			datatable.rest(req, res);
			datatable.search('webhooks.created_at', 'devices.session', 'webhooks.event', 'webhooks.url', 'webhooks.status', 'webhooks.id');
			datatable.params([
				['select', 'webhooks.created_at', 'devices.session', 'webhooks.event', 'webhooks.url', 'webhooks.status', 'webhooks.id', 'webhooks.data', 'webhooks.response'],
				['join', 'devices', 'devices.id', '=', 'webhooks.device_id'],
				['where', 'devices.user_id', '=', req.auth.user('id')],
			]);
			return await datatable.render();
		} catch(err) {
			res.status(500).json({
				message: err
			});
		}
	}

	return __constructor;
}

exports.inbox = ($) => {

	const __constructor = async function(req, res) {

		const datatable = $.library('datatables');

		try {
			datatable.init('messages');
			datatable.rest(req, res);
			datatable.search('messages.created_at', 'devices.name', 'messages.phone', 'messages.message', 'messages.status');
			datatable.params([
				['select', 'messages.created_at', 'devices.name as device_name', 'messages.phone', 'messages.message', 'messages.status'],
				['join', 'devices', 'devices.id', '=', 'messages.device_id'],
				['where', 'messages.type', 'in'],
				['where', 'devices.user_id', '=', req.auth.user('id')],
			]);
			return await datatable.render();
		} catch(err) {
			res.status(500).json({
				message: err
			});
		}
	}

	return __constructor;
}

exports.outbox = ($) => {

	const __constructor = async function(req, res) {

		const datatable = $.library('datatables');

		try {
			datatable.init('messages');
			datatable.rest(req, res);
			datatable.search('messages.created_at', 'devices.name', 'messages.phone', 'messages.message', 'messages.status', 'messages.id');
			datatable.params([
				['select', 'messages.created_at', 'devices.name as device_name', 'messages.phone', 'messages.message', 'messages.status', 'messages.id'],
				['join', 'devices', 'devices.id', '=', 'messages.device_id'],
				['where', 'messages.type', 'out'],
				['where', 'devices.user_id', '=', req.auth.user('id')],
			]);
			return await datatable.render();
		} catch(err) {
			res.status(500).json({
				message: err
			});
		}
	}

	return __constructor;
}

exports.trial = ($) => {

	const __constructor = async function(req, res) {
		try {
			const pkge = await $.model('packages').findOne([
				['where', 'slug', '=', 'trial'],
				['where', 'status', '=', 'show']
			]);

			if(pkge) {
				const expired_at = moment().add(3, 'day').format('YYYY-MM-DD 23:59:59');

				const db = $.config('database');
				await db.table.transaction(async function(trx){
					const code = uniqid();
					const device_id = await $.model('devices').setTransaction(trx).insert({
						package_id: pkge.id,
						user_id: req.auth.user('id'),
						name: code,
						session: code,
						status: 'inactive',
						status_sub: 'DISCONNECTED',
						expired_at: expired_at,
						created_by: req.auth.user('id')
					});

					await $.model('notifications').setTransaction(trx).insert({
						user_id: req.auth.user('id'),
						type: 'General',
						message: "Aktifasi paket trial Berhasil!",
						is_show: '0',
						created_by: req.auth.user('id'),
					});

					await trx.commit();

					return res.json({
						redirect_to: $.base_url(`member_area/whatsapp/${device_id}/detail`),
						message: "Berhasil melakukan permintaan.",
					});
				});
			} else {
				return res.status(500).json({message: 'paket tidak ditemukan!'});
			}
		} catch(err) {
			console.log(err);
			return res.status(500).json({message: 'error tidak diketahui'});
		}
	}

	return __constructor;
}

exports.order = ($) => {

	const __constructor = async function(req, res) {
		try {
			if(req.validate.isEmpty()) {
				const pkg = $.helper('text').sanitize_alphanum(req.params.slug);
				const pkge = await $.model('packages').findOne([
					['where', 'slug', '=', pkg],
					['where', 'slug', '!=', 'trial']
				]);

				if(pkge) {
					const dur = req.body.duration;
					const bank_id = req.body.bank_id;
					const bank = await $.model('banks').findOne([
						['where', 'id', '=', bank_id]
					]);

					if(!bank) {
						return res.status(500).json({message: 'jenis pembayaran tidak ditemukan!'});
					}

					const expired_at = moment().add(parseInt(dur), 'month').format('YYYY-MM-DD 23:59:59');
					const amount = parseInt(pkge.price) * parseInt(dur);
					const additional = $.helper('text').random_number(0, 500);
					const amount_total = amount + additional;
					const idr = $.helper('text').number_format(amount);
					const bill_desc = `Anda melakukan pemesanan paket whatsapp ${pkge.name} selama ${dur} bulan.`;
					const code = uniqid();
					const bill_notif = `[${code}] Anda melakukan pemesanan paket whatsapp ${pkge.name} selama ${dur} bulan.`;

					const db = $.config('database');
					await db.table.transaction(async function(trx){

						const device_id = await $.model('devices').setTransaction(trx).insert({
							package_id: pkge.id,
							user_id: req.auth.user('id'),
							name: code,
							session: code,
							status: 'unpaid',
							status_sub: 'DISCONNECTED',
							expired_at: expired_at,
							created_by: req.auth.user('id')
						});

						await $.model('bills').setTransaction(trx).insert({
							reference_table: 'devices',
							reference_id: device_id,
							invoice: code,
							description: bill_desc,
							amount: amount_total,
							amount_additional: additional,
							amount_request: amount,
							type: "Order",
							status: "Pending",
							bank_id: bank_id,
							bank_account: bank.account_name,
							bank_address: bank.account_address,
							user_id: req.auth.user('id'),
							created_by: req.auth.user('id')
						});

						await $.model('notifications').setTransaction(trx).insert({
							user_id: req.auth.user('id'),
							type: 'General',
							message: bill_notif,
							is_show: '0',
							created_by: req.auth.user('id'),
						});

						await trx.commit();
					});

					$.service('mail').bill_create({
						invoice: code,
						email: req.auth.user('email'),
						name: req.auth.user('name'),
						username: req.auth.user('username'),
						bank_name: bank.name,
						rekening_nama: bank.account_name,
						description: `pembelian paket whatsapp ${pkge.name} selama ${dur} bulan`,
						rekening_nomor: bank.account_address,
						created_at: $.helper('text').get_datetime(),
						amount_request: $.helper('text').number_format(amount),
						amount_additional: $.helper('text').number_format(additional),
						amount: $.helper('text').number_format(amount_total),
						status: "Pending",
					});
					return res.json({
						redirect_to: $.base_url(`member_area/bills/invoice/${code}`),
						message: "Berhasil melakukan permintaan.",
					});
				} else {
					return res.status(500).json({message: 'paket tidak ditemukan!'});
				}
			} else {
				return res.status(400).json({
					message: "Periksa kembali form anda.",
					errors: req.validate.get_errors()
				});
			}
		} catch(err) {
			console.log(err);
			return res.status(500).json({message: 'error tidak diketahui'});
		}
	}

	return __constructor;
}

exports.renew = ($) => {

	const __constructor = async function(req, res) {
		try {
			if(req.validate.isEmpty()) {
				const id = $.helper('text').sanitize_int(req.params.id);
				const device = await $.model('devices').findOne([
					['where', 'id', '=', id]
				]);

				if(device) {
					const dur = req.body.duration;
					const bank_id = req.body.bank_id;
					const pkge = await $.model('packages').findOne([
						['where', 'id', '=', device.package_id],
						['where', 'slug', '!=', 'trial']
					]);

					const bank = await $.model('banks').findOne([
						['where', 'id', '=', bank_id]
					]);

					if(!pkge) {
						return res.status(500).json({message: 'paket tidak ditemukan!'});
					}

					if(!bank) {
						return res.status(500).json({message: 'jenis pembayaran tidak ditemukan!'});
					}

					const expired_at = moment(device.expired_at).add(parseInt(dur), 'month').format('YYYY-MM-DD 23:59:59');
					const amount = parseInt(pkge.price) * parseInt(dur);
					const additional = $.helper('text').random_number(0, 500);
					const amount_total = amount + additional;
					const idr = $.helper('text').number_format(amount);
					const bill_desc = `Anda melakukan perpanjangan masa aktif whatsapp ${device.session} selama ${dur} bulan.`;
					const code = uniqid();
					const bill_notif = `[${code}] Anda melakukan perpanjangan masa aktif whatsapp ${device.session} selama ${dur} bulan.`;

					const db = $.config('database');
					await db.table.transaction(async function(trx){

						await $.model('bills').setTransaction(trx).insert({
							reference_table: 'devices',
							reference_id: id,
							invoice: code,
							description: bill_desc,
							amount: amount_total,
							amount_additional: additional,
							amount_request: amount,
							params: JSON.stringify({
								device: {
									expired_at,
									status: (device.status !== 'active' ? 'inactive' : 'active')
								}
							}),
							type: "Renew",
							status: "Pending",
							bank_id: bank_id,
							bank_account: bank.account_name,
							bank_address: bank.account_address,
							user_id: req.auth.user('id'),
							created_by: req.auth.user('id')
						});

						await $.model('notifications').setTransaction(trx).insert({
							user_id: device.user_id,
							type: 'General',
							message: bill_notif,
							is_show: '0',
							created_by: req.auth.user('id'),
						});

						$.service('mail').bill_create({
							invoice: code,
							email: req.auth.user('email'),
							name: req.auth.user('name'),
							username: req.auth.user('username'),
							bank_name: bank.name,
							rekening_nama: bank.account_name,
							description: `perpanjangan paket whatsapp ${pkge.name} selama ${dur} bulan`,
							rekening_nomor: bank.account_address,
							created_at: $.helper('text').get_datetime(),
							amount_request: $.helper('text').number_format(amount),
							amount_additional: $.helper('text').number_format(additional),
							amount: $.helper('text').number_format(amount_total),
							status: "Pending",
						});

						await trx.commit();
					});
					return res.json({
						redirect_to: $.base_url(`member_area/bills/invoice/${code}`),
						message: "Berhasil melakukan permintaan.",
					});
				} else {
					return res.status(500).json({message: 'perangkat tidak ditemukan!'});
				}
			} else {
				return res.status(400).json({
					message: "Periksa kembali form anda.",
					errors: req.validate.get_errors()
				});
			}
		} catch(err) {
			console.log(err);
			return res.status(500).json({message: 'error tidak diketahui'});
		}
	}

	return __constructor;
}

exports.autoreplies = ($) => {

	const __constructor = async function(req, res) {

		const datatable = $.library('datatables');

		try {
			datatable.init('auto_replies');
			datatable.rest(req, res);
			datatable.search('auto_replies.created_at', 'auto_replies.message', 'devices.session', 'auto_replies.status', 'auto_replies.id');
			datatable.params([
				['select', 'auto_replies.created_at', 'auto_replies.message', 'devices.session', 'auto_replies.status', 'auto_replies.id', 'devices.name as device_name', 'auto_replies.reply', 'auto_replies.device_id', 'auto_replies.is_regex'],
				['join', 'devices', 'devices.id', '=', 'auto_replies.device_id'],
				['where', 'devices.user_id', '=', req.auth.user('id')],
			]); 
			return await datatable.render();
		} catch(err) {
			res.status(500).json({
				message: err
			});
		}
	}

	return __constructor;
}

exports.autoreply_add = ($) => {

	const __constructor = async function(req, res) {
		try {
			if(req.validate.isEmpty()) {
				const device_id = $.helper('text').sanitize_int(req.body.device_id);
				const device = await $.model('devices').findOne([
					['where', 'id', '=', device_id],
					['where', 'user_id', '=', req.auth.user('id')],
				]);

				if(device) {

					const is_regex = req.body?.is_regex ? req.body.is_regex : 'No';
					const data = {
						device_id: req.body.device_id,
						is_regex,
						message: req.body.message,
						reply: req.body.reply,
						status: req.body.status,
						created_by: req.auth.user('id')
					}

					await $.model('autoreplies').insert(data)

					$.model('autoreplies').findAll([
						['where', 'status', 'Active'],
						['where', 'device_id', device_id]
					]).then(function(m){
						if(devices.get(device.session)) {
							devices.get(device.session).setAutoReplies(m);
						}
					}).catch(function(er){
						console.log(er);
					});

					return res.json({
						message: "Perubahan disimpan!"
					});

				} else {
					return res.status(500).json({message: 'perangkat tidak ditemukan.'});
				}
			} else {
				return res.status(400).json({
					message: "Periksa kembali form anda.",
					errors: req.validate.get_errors()
				});
			}
		} catch(err) {
			console.log(err);
			return res.status(500).json({message: 'error tidak diketahui'});
		}
	}

	return __constructor;
}

exports.autoreply_update = ($) => {

	const __constructor = async function(req, res) {
		try {
			if(req.validate.isEmpty()) {
				const id = $.helper('text').sanitize_int(req.params.id);
				const device_id = $.helper('text').sanitize_int(req.body.device_id);
				const check = await $.model('autoreplies').findOne([
					['select', 'auto_replies.*', 'session'],
					['join', 'devices', 'devices.id', '=', 'auto_replies.device_id'],
					['where', 'devices.user_id', '=', req.auth.user('id')],
					['where', 'auto_replies.id', '=', id]
				]);

				if(check) {
					const is_regex = req.body?.is_regex ? req.body.is_regex : 'No';
					const data = {
						device_id,
						is_regex,
						message: req.body.message,
						reply: req.body.reply,
						status: req.body.status,
						updated_by: req.auth.user('id')
					}

					await $.model('autoreplies').update(id, data);

					$.model('autoreplies').findAll([
						['where', 'status', 'Active'],
						['where', 'device_id', device_id]
					]).then(function(m){
						if(devices.get(check.session)) {
							devices.get(check.session).setAutoReplies(m);
						}
					}).catch(function(er){
						console.log(er);
					});

					return res.json({
						message: "Perubahan disimpan!"
					});
				} else {
					return res.status(500).json({message: 'data tidak ditemukan.'});
				}
			} else {
				return res.status(400).json({
					message: "Periksa kembali form anda.",
					errors: req.validate.get_errors()
				});
			}
		} catch(err) {
			console.log(err);
			return res.status(500).json({message: 'error tidak diketahui'});
		}
	}

	return __constructor;
}