const filter = require("../../system/filters/filter.js");
const jwt = require("jsonwebtoken");

class base_filters extends filter {

	constructor() {
		super()
	}

	async session_check(token) {
		let decoded = jwt.verify(token, this.config("app").jwtPrivateKey);
		let user = await this.model('users').findOne([
			['where', 'id', decoded.id],
			['where', 'status', 'active']
		]);
		
		return user;
	}

	async api_check(key) {
		let user = await this.model('users').findOne([
			['where', 'api_key', key],
			['where', 'status', 'active']
		]);
		
		return user;
	}

	async security_check(req) {
		if(req.headers.api_key || false) return ["api_key", req.headers.api_key];
		if(req.cookies[this.config("app").session_name] || false) return ["session", req.cookies[this.config("app").session_name]];
		return ['unauthenticated', undefined];
	}

}

module.exports = base_filters;