const jwt = require("jsonwebtoken");
const __base_filters = require("./base_filters.js");
const handlebars = require('handlebars');

module.exports = (...params) => {

	const [$, param] = params;
	const base_filters = new __base_filters();
	const __constructor = async function(req, res, next) {
		
		const [type, token] = await base_filters.security_check(req);
		req.auth = $.service('authentication');

		if(typeof token === 'string') {
			try {
				let user = [];
				if(type == 'session') {
					user = await base_filters.session_check(token);
				} else {
					user = await base_filters.api_check(token);
				}
				if(user) {
					req.auth.set_userdata(user);
				} else {
					req.auth.clear_userdata();
				}
			} catch(err) {
				console.log(err);
			}
		} else {
			req.auth.clear_userdata();
		}


		res.renderMemberArea = async function(path, params=null) {

			handlebars.registerHelper('user', function (key, options) {
			  return req.auth.user(key);
			});

			const m_notif = $.model('notifications');


			const notifications = await m_notif.findAll([
				['where', 'user_id', '=', req.auth.user('id')],
				['where', 'is_show', '=', '0'],
				['orderBy', 'id', 'desc'],
				['limit', '10'],
			]);

			const notif_count = (await m_notif.findOne([
				['select', m_notif.table.raw('IFNULL(count(0), 0) as total')],
				['where', 'user_id', '=', req.auth.user('id')],
				['where', 'is_show', '=', '0'],
			])).total;

			let group = req.auth.user('group');
			let view_params = {
				layout: "member_area",
				notifications,
				notif_count,
				sidebar_path: `member_area/sidebar_${ group }`,
			}
			if(params) {
				view_params = Object.assign(view_params, params);
			}
			return res.render(`member_area/${path}`, view_params);
		}

		res.renderLandingPage = function(path, params=null) {

			handlebars.registerHelper('user', function (key, options) {
			  return req.auth.user(key);
			});

			let view_params = {
				layout: "landing_page",
			}
			if(params) {
				view_params = Object.assign(view_params, params);
			}
			return res.render(`landing_page/${path}`, view_params);
		}

		next();
	}

	return __constructor;
}