const database = require("../configs/database.js");

module.exports = class extends database {

    _table_name = undefined;
    _params = undefined; 
    _search = []; 
    req = undefined; 
    res = undefined; 

    constructor() {
        super();
    }

    init(table) {
        this._table_name = table;
        return this;
    }

    rest(req, res) {
        this.req = req;
        this.res = res;
        return this;
    }

    params(params) {
        this._params = params;
        return this;
    }

    search(...s) {
        this._search = s;
        return this;
    }

    async findOne(params=false) {
		const qb = this.table(this._table_name);
		const filters = [];
		var noSelect = true;
		var addLimit = true;

		if(Array.isArray(params)) {
			params.forEach((v, k)=>{
				if(
                    v.indexOf('select') > -1 || 
                    v.indexOf('count') > -1 || 
                    v.indexOf('sum') > -1
                ) noSelect = false;

                if(
                    v.indexOf('count') > -1 || 
                    v.indexOf('sum') > -1
                ) addLimit = false;
                
				filters.push(v);
			});
		}

		if(noSelect) {
			filters.push(['select', '*']);
		}

		if(addLimit) {
			filters.push(['limit', '1']);
		}

		filters.forEach((v, k)=>{
		    const params = Object.assign([], v);
		    params.splice(0,1);
		    qb[v[0]](...params);
		})
        const [data] = (await qb) || [];
		return data;
	}

	async findAll(params=false) {
		const qb = this.table(this._table_name);
		const filters = [];
		var noSelect = true;

		if(Array.isArray(params)) {
			params.forEach((v, k)=>{
				if(
                    v.indexOf('select') > -1 || 
                    v.indexOf('count') > -1 || 
                    v.indexOf('sum') > -1
                ) noSelect = false;
				filters.push(v);
			});
		}

		if(noSelect) {
			filters.push(['select', '*']);
		}

		filters.forEach((v, k)=>{
		    const params = Object.assign([], v);
		    params.splice(0,1);
		    qb[v[0]](...params);
		})
		return qb;
	}

    async render(params={}) {
        try {
            const start = this.req.body.start || 0;
            const length = this.req.body.length || 10;
            const search = this.req.body.search['value'] || "";
            const orderColumn = this.req.body.order ? this.req.body.order[0]['column'] : "";
            const orderDir = this.req.body.order ? this.req.body.order[0]['dir'] : "asc";

            if(this._search.length==0) {
                this._params.filter(data => {
                    if(data.includes('select')) {
                        data.filter(d => {
                            if(d !== 'select') {
                                const regx = d.match(/.+?(?=\sas)/gi);
                                if(regx) {
                                    const [col] = regx;
                                    this._search.push(col);
                                } else {
                                    this._search.push(d);
                                }
                            }
                        })
                    }
                })
            }

            if(search.length > 0 && this._search.length > 0) {
                let isHavingWhere = false;

                this._params.filter(data => {
                    if(data.includes('where')) {
                        isHavingWhere = true;
                    } 
                })

                if(this._search.length > 0) {
                    this._params.push(['where', (qb)=> {
                        this._search.forEach((v, k) => {
                            qb.orWhere(v, 'like', `%${search}%`);
                        })
                    }]);
                }
            }

            if(orderColumn.length > 0) {
                const column = this._search[orderColumn];
                this._params.push(['orderBy', column, orderDir]);
            }

            this._params.push(['limit', length]);
            this._params.push(['offset', start]);
            const data = await this.findAll(this._params);
            const draw = this.req.body.draw;
            const rawFilter = this._params.filter(data => {
                if( 
                    !data.includes('select') && 
                    !data.includes('limit') &&
                    !data.includes('offset')
                ){
                    return true;
                }
            });


            const recordsFilter = [ ['count', `${this._table_name}.id as total`] ].concat(rawFilter);
            const getRecords = await this.findOne(recordsFilter);
            const recordsFiltered = getRecords.total || 0;
            const recordsTotal = recordsFiltered;

            let s = {
                draw: draw,
                data: data,
                recordsFiltered: recordsFiltered,
                recordsTotal: recordsTotal,
            }

            if(typeof params === 'object') {
                s = Object.assign(s, params);
            } 

            return this.res.json(s);
        } catch (error) {
            console.log(error);
            let s = {
                draw: draw,
                data: [],
                recordsFiltered: 0,
                recordsTotal: 0,
            }

            if(typeof params === 'object') {
                s = Object.assign(s, params);
            }

            return this.res.json(s);
        }
    }

}