const { body, validationResult } = require("express-validator");

module.exports = function(routes) {

	routes.group("/api", function(routes){

		routes.group("/auth", function(routes){
			routes.post("/login", routes.validation("auth:login"), routes.controller("api/auth:login"));
			routes.post("/register", routes.validation("auth:register"), routes.controller("api/auth:register"));
			routes.post("/forgot", routes.validation("auth:forgot"), routes.controller("api/auth:forgot"));
			routes.post("/new_password", routes.validation("auth:new_password"), routes.controller("api/auth:new_password"));
		});

		routes.group("/v1", routes =>{
			routes.post("/:code/send_text", routes.filter("auth"), routes.validation('v1:send_text'), routes.controller("api/v1:send_text"));
			routes.post("/:code/send_image", routes.filter("auth"), routes.validation('v1:send_image'), routes.controller("api/v1:send_image"));
			routes.post("/:code/send_audio", routes.filter("auth"), routes.validation('v1:send_audio'), routes.controller("api/v1:send_audio"));
			routes.post("/:code/send_video", routes.filter("auth"), routes.validation('v1:send_video'), routes.controller("api/v1:send_video"));
			routes.post("/:code/send_document", routes.filter("auth"), routes.validation('v1:send_document'), routes.controller("api/v1:send_document"));
		});

		routes.group("/notifications", routes.filter("auth"), routes =>{
			routes.post("/datatables", routes.controller("api/notifications:datatables"));
			routes.post("/:id/changestatus", routes.validation("notifications:changestatus"), routes.controller("api/notifications:changestatus"));
		});

		routes.group("/paymentmethods", routes.filter("auth"), routes =>{
			routes.post("/datatables", routes.controller("api/paymentmethods:datatables"));
			routes.post("/:id/update", routes.validation("paymentmethods:update"), routes.controller("api/paymentmethods:update"));
			routes.post("/create", routes.validation("paymentmethods:create"), routes.controller("api/paymentmethods:create"));
		});	

		routes.post("/profile", routes.validation("profile:update"), routes.filter("auth"), routes.controller("api/profile:update"));

		routes.group("/whatsapp", routes.filter("auth"), routes => {
			routes.get("/events", routes.controller("api/whatsapp:events"));
			routes.post("/create", routes.controller("api/whatsapp:create"));
			routes.post("/devices", routes.controller("api/whatsapp:devices"));
			routes.post("/inbox", routes.controller("api/whatsapp:inbox"));
			routes.post("/outbox", routes.controller("api/whatsapp:outbox"));
			routes.post("/webhooks", routes.controller("api/whatsapp:webhooks"));
			routes.post("/:id/update", routes.validation("whatsapp:update"), routes.controller("api/whatsapp:update"));
			routes.post("/:id/renew", routes.validation("whatsapp:renew"), routes.controller("api/whatsapp:renew"));
			routes.post("/order/:slug", routes.validation("whatsapp:order"), routes.controller("api/whatsapp:order"));
			routes.post("/trial/order", routes.controller("api/whatsapp:trial"));
			routes.post("/autoreplies", routes.controller("api/whatsapp:autoreplies"));
			routes.post("/autoreply/add", routes.validation("whatsapp:autoreply"), routes.controller("api/whatsapp:autoreply_add"));
			routes.post("/autoreply/:id/update", routes.validation("whatsapp:autoreply"), routes.controller("api/whatsapp:autoreply_update"));
		});

		routes.group("/bills", routes.filter("auth"), routes => {
			routes.post("/invoices", routes.controller("api/bills:invoices"));
			routes.post("/requests", routes.filter("ingroup:admin"), routes.controller("api/bills:requests"));
			routes.post("/:id/changestatus",  routes.filter("ingroup:admin"), routes.validation("bills:changestatus"), routes.controller("api/bills:changestatus"));
		});

		routes.group("/users", routes.filter("auth"), function(routes) {
			routes.post("/register", routes.validation("users:register"), routes.controller("api/users:register"));
			routes.post("/:id/update", routes.validation("users:update"), routes.controller("api/users:update"));
			routes.post("/datatable", routes.controller("api/users:datatable"));
		});

	});

}