const devices = require('./devices.js');
const moment = require('moment');
const deviceModel = require('../models/devices.js');

function write_log(code, msg) {
	console.log(`|- ${moment().format('DD/MM/YYYY HH:mm:ss')} -|`);
	console.log(`socket[${code}] : ${msg}`);
	console.log(`|-----------------------|`);
}

module.exports = function(io) {

	io.of('/device').on('connection', async function(l){
		const _s = l.handshake.query.session;

		const _m = new deviceModel();

		const device = await _m.findOne([
			['where', 'session', '=', _s]
		]);

		l.emit('connection', {
			message: 'Sedang menyambungkan!',
			actions: []
		});

		if(_s && device) {

			const registerEvent = function(code) {
				const instance = devices.get(code);
				if(instance) {
					l.emit('connecting', {
						message: 'Sedang menyambungkan!',
						actions: ['restart'],
					});

					if(instance.isConnected()) {
						l.emit('connected', {
							message: 'Perangkat telah tersambung!',
							actions: ['restart', 'logout']
						});
					}

					instance.on('connecting', function(){
						l.emit('connecting', {
							message: 'Sedang menyambungkan!',
							actions: ['restart'],
						});
					});

					instance.on('connected', function(){
						l.emit('connected', {
							message: 'Berhasil tersambung!',
							actions: ['restart', 'logout']
						});
					});

					instance.on('disconnected', function(){
						l.emit('disconnected', {
							message: 'Sambungan terputus!',
							actions: ['restart']
						});
					});

					instance.on('qr', function(qr){
						l.emit('qr', {
							qr,
							message: 'Scan QR code di atas!',
							actions: ['restart']
						});
					});

					l.on('restart', function(){
						instance.restart();
					});

					l.on('logout', function(){
						instance.logout();
					});
				} else {
					l.emit('disconnected', {
						message: 'Hidupkan perangkat!',
						actions: ['start']
					});

					l.on('start', function(){
						devices.register(device);
						registerEvent(code);
					});
				}
			}

			switch(device.status) {
				case 'active':
					registerEvent( _s );
					break;

				case 'inactive':
						l.emit('disconnected', {'message': 'Perangkat sedang dimatikan!'});
					break;

				case 'unpaid':
						l.emit('disconnected', {'message': 'Tagihan belum dibayar!'});
					break;

				case 'expired':
						l.emit('disconnected', {'message': 'Perangkat telah kedaluarsa!'});
					break;
			}
		} else {
			l.emit('disconnected', {'message': 'Perangkat tidak ditemukan!'});
		}
	});

	
}