const express = require("express");
const socketio = require('socket.io');
const http = require('http')
const os = require("os");
const bodyParser = require("body-parser");
const cookieParser = require("cookie-parser");
const cors = require('cors');
const { create } = require('express-handlebars');
const app = express();
const formData = require("express-form-data");
const system = require('./system.js');
const router = require("../app/configs/router.js");
const server = http.createServer(app);
const sockets = require("../app/statics/sockets.js");
const devices = require("../app/statics/devices.js");
const crons = require("../app/statics/crons.js");
const io = socketio(server);
const $ = new system();

//multipart formdata support
const options = {
	uploadDir: os.tmpdir(),
	autoClean: true
};

if(true) {
	new sockets(io);
	new crons();
	devices.startAll();
}

// parse data with connect-multiparty. 
app.use(formData.parse(options));
// delete from the request all empty files (size == 0)
app.use(formData.format());
// change the file objects to fs.ReadStream 
app.use(formData.stream());
// union the body and the files
app.use(formData.union());

//Body Parser
app.use(bodyParser.json());
app.use(bodyParser.urlencoded( { extended: true } ));
app.use(cors()); 

//Cookie Parser
app.use(cookieParser());

// ignore route public dir
app.use(express.static('public'));

//set template engine
const hbs = create({
	defaultLayout: false,
	helpers: $.helper('handlebars'),
	extname: '.html'
});

app.set('view engine', 'html');
app.engine('html', hbs.engine);
app.set('views', './src/app/views');

//add router custom method
express.Router.controller = $.controller;
express.Router.filter = $.filter;
express.Router.validation = $.validation;
express.Router.group = function(arg1, arg2, arg3) {
	let handlerFunction = arg1;
	let path = '/';
	let middlewares = null;

	if (arg3) {
		path = arg1;
		middlewares = arg2;
		handlerFunction = arg3;
	} else if (arg2) {
		path = arg1;
		handlerFunction = arg2;
	}
	const router = express.Router();
	if(middlewares) {
		if (typeof middlewares == 'object') {
			middlewares.map(middleware => {
				router.use(middleware);
			});
		} else {
			router.use(middlewares);
		}
	}
	handlerFunction(router);
	this.use(path, router);
	return this;
};

app.use(function(req, res, next){
	req.$ = $;
	next();
});

new router(app);

module.exports = server;